/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.painter.decoration;

import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceSkin;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.decoration.SubstanceDecorationPainter;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class MatteDecorationPainter
implements SubstanceDecorationPainter {
    public static final String DISPLAY_NAME = "Matte";

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public void paintDecorationArea(Graphics2D graphics, Component comp, DecorationAreaType decorationAreaType, int width, int height, SubstanceSkin skin) {
        switch (decorationAreaType) {
            case PRIMARY_TITLE_PANE: 
            case SECONDARY_TITLE_PANE: {
                this.paintTitleBackground(graphics, comp, width, height, skin.getBackgroundColorScheme(decorationAreaType));
                break;
            }
            default: {
                this.paintExtraBackground(graphics, SubstanceCoreUtilities.getHeaderParent(comp), comp, width, height, skin.getBackgroundColorScheme(decorationAreaType));
            }
        }
    }

    private void paintTitleBackground(Graphics2D graphics, Component comp, int width, int height, SubstanceColorScheme scheme) {
        Graphics2D temp = (Graphics2D)graphics.create();
        this.fill(temp, scheme, 0, 0, 0, width, height);
        temp.dispose();
    }

    private void paintExtraBackground(Graphics2D graphics, Container parent, Component comp, int width, int height, SubstanceColorScheme scheme) {
        JRootPane rootPane = SwingUtilities.getRootPane(parent);
        int dx = 0;
        int dy = 0;
        JComponent titlePane = null;
        if (rootPane != null && (titlePane = SubstanceCoreUtilities.getTitlePane(rootPane)) != null) {
            if (comp.isShowing() && titlePane.isShowing()) {
                dx += comp.getLocationOnScreen().x - titlePane.getLocationOnScreen().x;
                dy += comp.getLocationOnScreen().y - titlePane.getLocationOnScreen().y;
            } else {
                Component c;
                dx = 0;
                dy = 0;
                for (c = comp; c != rootPane; c = c.getParent()) {
                    dx += c.getX();
                    dy += c.getY();
                }
                for (c = titlePane; c != rootPane; c = c.getParent()) {
                    dx -= c.getX();
                    dy -= c.getY();
                }
            }
        }
        Graphics2D temp = (Graphics2D)graphics.create();
        this.fill(temp, scheme, dy, 0, 0, width, height);
        temp.dispose();
    }

    protected void fill(Graphics2D graphics, SubstanceColorScheme scheme, int offsetY, int x, int y, int width, int height) {
        int flexPoint = 50;
        int startY = y + offsetY;
        int endY = y + offsetY + height;
        int currStart = 0;
        if (flexPoint >= startY) {
            graphics.setPaint(new GradientPaint(x, currStart - offsetY, scheme.getLightColor(), x, flexPoint - offsetY, scheme.getMidColor()));
            graphics.fillRect(x, currStart - offsetY, width, flexPoint);
        }
        if ((currStart += flexPoint) > endY) {
            return;
        }
        graphics.setColor(scheme.getMidColor());
        graphics.fillRect(x, currStart - offsetY, width, endY - currStart + offsetY);
    }
}

